#--------------------------------------------------------------------------------------
#
# utils.R utilities for managing ToxCast data
#
# December 2012
# Richard Judson
#  
# US EPA
# Questions, comments to: judson.richard@epa.gov
#
#
#--------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------
#
# do an or on a chunk of a matrix
#
#-----------------------------------------------------------------------------------
aORb <<- function(V,M) {
    res <- c()
    for(i in 1:dim(M)[1]) res <- c(res,sum(V|M[i,]))
    return(res)
}
#--------------------------------------------------------------------------------------
#
# uniquify - take a list and get the unique set
# 
#--------------------------------------------------------------------------------------
uniquify <- function(x) {
	temp <- duplicated(x)
	y <- x[!temp]
	return(y)
}
#--------------------------------------------------------------
#
# calculate the paramteres for a 2 x 2 matrix
#
#--------------------------------------------------------------
TxT<<- function(tp,fp,fn,tn,do.p=TRUE) {

	sens<-tp/(tp+fn)
	spec<-tn/(tn+fp)
	ppv<-tp/(tp+fp)
	npv<-tn/(tn+fn)

	relative.risk <- (tp/(tp+fp)) / (fn/(tn+fn))
	odds.ratio <- (tp*tn)/(fp*fn)

	accuracy <- (tp+tn)/(tp+tn+fp+fn)
	x<-matrix(data=NA, nrow=2, ncol=2)
	x[1,1]<-tp
	x[1,2]<-fp
	x[2,1]<-fn
	x[2,2]<-tn
	if(is.infinite(relative.risk))  relative.risk <- 1000000
	if(is.infinite(odds.ratio))  odds.ratio <- 1000000
	if(is.infinite(sens))  sens <- 0
	if(is.infinite(spec))  spec <- 0
	if(is.nan(relative.risk))  relative.risk <- 1
	if(is.nan(odds.ratio))  odds.ratio <- 1
	if(is.nan(sens))  sens <- 0
	if(is.nan(spec))  spec <- 0
	if(is.na(sens))  sens <- 0
	if(is.na(spec))  spec <- 0

	p.value<-1
	if(do.p==TRUE) {
		if(sens>0 && spec>0) {
			c<-fisher.test(x)
			p.value <- c$p.value
		}
	}
	ba <- 0.5*(sens+spec)

	sval<-paste(tp,"\t",fp,"\t",fn,"\t",tn,"\t",format(sens,digits=3),"\t",format(spec,digits=3),"\t",format(ba,digits=3),"\t",format(accuracy,digits=3),"\t",format(relative.risk,digits=3),"\t",format(odds.ratio,digits=3),"\t",format(ppv,digits=3),"\t",format(npv,digits=3),"\t",format(p.value,digits=3),sep="")
	title<-paste("TP\tFP\tFN\tTN\tSens\tSpec\tBA\tAcrcy\tRelRsk\tOR\tPPV\tNPV\tp.value",sep="")
  	r<<-list(a=tp,b=fp,c=fn,d=tn,sens=sens,spec=spec,ba=ba,accuracy=accuracy,relative.risk=relative.risk,odds.ratio=odds.ratio,ppv=ppv,npv=npv,p.value=p.value,sval=sval,title=title)

	r
}
#-----------------------------------------------------------------------------------
#
# chisq on a single variable
#   used as the inner function for factor selection
#
#-----------------------------------------------------------------------------------
chisq_1Var <- function(x,Class) {
	y <- Class[,1]
	a <-sum(x*y)
	b <- sum(x*(1-y))
	c <- sum((1-x)*y)
	d <- sum((1-x)*(1-y))
	txt <- TxT(a,b,c,d)
	return(txt)
}
#-----------------------------------------------------------------------------------
#
# minimum by col
#
#-----------------------------------------------------------------------------------
colMin <- function(x) {
	ret <- apply(x,FUN=min,MARGIN=2)
}
#-----------------------------------------------------------------------------------
#
# maximum by col
#
#-----------------------------------------------------------------------------------
colMax <- function(x) {
	ret <- apply(x,FUN=max,MARGIN=2)
}
#-----------------------------------------------------------------------------------
#
# minimum by col
#
#-----------------------------------------------------------------------------------
colMedian <- function(x) {
	ret <- apply(x,FUN=median,MARGIN=2)
}
#-----------------------------------------------------------------------------------
#
# minimum by row
#
#-----------------------------------------------------------------------------------
rowMin <- function(x) {
	ret <- apply(x,FUN=min,MARGIN=1)
}
#-----------------------------------------------------------------------------------
#
# maximum by row
#
#-----------------------------------------------------------------------------------
rowMax <- function(x) {
	ret <- apply(x,FUN=max,MARGIN=1)
}

